--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
--                                                         %%
--  LABORATORIO DE PROGRAMACION V                          %%
--  Programacion FUNCIONAL                                 %%
--  18-02-98                                               %%
--			                                   %%
--  SOLUCIONES                                             %%
--                                                         %%

--------------
-- EJERCICIO 1
--------------

primo :: Int -> Bool
-- primo n ===  el nmero n es primo

primo 1 = False
primo n = and [ n `mod` d /=0 | d<-[2..n-1] ]

divisoresPrimos :: Int -> [Int]
-- divisoresPrimos n === la lista de divisores primos de n

divisoresPrimos n = [ p |  p<-[2..n],
			   n `mod` p == 0,
			   primo p ]
--------------
-- EJERCICIO 2
--------------

gradoDe :: Int -> Int -> Int 
-- el grado con que aparece p en la descomposicin en factores primos
gradoDe n p 
   | n `mod` p /= 0  = 0
   | otherwise       = 1 + gradoDe (n `div` p) p


factorizacion :: Int -> [(Int,Int)]

factorizacion n = [ (p,gradoDe n p) | p<-divisoresPrimos n]

--------------
-- EJERCICIO 3
--------------

mcd a b = foldr (\(p,e) v -> p^e*v) 1 
	[ (p,min e e') | (p,e)   <- factorizacion a,
			 (p',e') <- factorizacion b,
			  p' == p]

-- este ejercicio corresponde al apartado 3b. de Prog. Declarativa
mcm a b = foldr (\(p,e) v -> p^e*v) 1 (cync f f')
  where f  = factorizacion a
	f' = factorizacion b

-- comunes con mayor exponente y no comunes
cync []   ws'  = ws'
cync ws   []   = ws  
cync ws@((p,e):ps) ws'@((p',e'):ps')
  | p == p'   = (p,max e e') : cync ps ps'
  | p  < p'   = (p,e):cync ps ws'
  | otherwise = (p',e'):cync ws ps'

